import type { Metadata } from "next";
import "./css/main.css";
import "@fortawesome/fontawesome-free/css/all.min.css";
import "@fancyapps/ui/dist/fancybox/fancybox.css";
import Header from "./components/header/Header";
import Footer from "./components/footer/Footer";

export const metadata: Metadata = {
  title: {
    default: "بیمارستان رضوی",
    template: "%s | بیمارستان رضوی",
  },
  description: "بیمارستان فوق تخصصی رضوی - خدمات پزشکی و درمانی",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="fa" dir="rtl">
      <body>
        <main className="relative">
            <Header/>
            {children}
            <Footer/>
        </main>
        
      </body>
    </html>
  );
}
