import { getHomePage } from "@/src/lib/homeApi";
import SocialSection from "./components/home/SocialSection";
import HeroSlider from "./components/home/HeroSlider";
import ServicesSection from "./components/home/ServicesSection";
import DoctorsSection from "./components/home/DoctorsSection";
import AboutSection from "./components/home/AboutSection";
import VirtualTour from "./components/home/VirtualTour";
import GallerySection from "./components/home/GallerySection";
import Testimonials from "./components/home/Testimonials";
import InsuranceSection from "./components/home/InsuranceSection";
import Certificates from "./components/home/Certificates";
import BlogSection from "./components/home/BlogSection";
import FaqSection from "./components/home/FaqSection";

export default async function Home() {
  const data = await getHomePage();

  return (
    <main>
      <SocialSection socials={data.socialNetworks} />
      <HeroSlider heroSlider={data.bannersSection} />
      <ServicesSection services={data.servicesSection} />
      <DoctorsSection
  title={data.doctorsSection.title}
  subtitle={data.doctorsSection.subtitle}
  description={data.doctorsSection.description}
  doctors={data.doctorsSection.doctors}
/>
      <AboutSection about={data.aboutSection} />
      <VirtualTour virtualTour={data.virtualToursSection}/>
      <GallerySection gallery={data.galleriesSection} />
      <Testimonials comments={data.commentsSection} />
      <InsuranceSection insurance={data.contractedInsurancesSection} />
      <Certificates certificatesData={data.certificatesSection} />
      <BlogSection news={data.blogsSection} />
      <FaqSection faqs={data.faqsSection} />
    </main>
  );
}
