/**
 * Swiper Custom Element 12.0.3
 * Most modern mobile touch slider and framework with hardware accelerated transitions
 * https://swiperjs.com
 *
 * Copyright 2014-2025 Vladimir Kharlampidi
 *
 * Released under the MIT License
 *
 * Released on: October 21, 2025
 */

import{S as Swiper}from"./shared/swiper-core.min.mjs";import{p as paramsList,n as needsNavigation,a as needsPagination,b as needsScrollbar,u as updateSwiper,c as attrToProp}from"./shared/update-swiper.min.mjs";import{g as getParams}from"./shared/get-element-params.min.mjs";import{s as setInnerHTML}from"./shared/utils.min.mjs";const SwiperCSS=':host{--swiper-theme-color:#007aff}:host{display:block;margin-left:auto;margin-right:auto;position:relative;z-index:1}.swiper{display:block;height:100%;list-style:none;margin-left:auto;margin-right:auto;overflow:hidden;padding:0;position:relative;width:100%;z-index:1}.swiper-vertical>.swiper-wrapper{flex-direction:column}.swiper-wrapper{box-sizing:initial;display:flex;height:100%;position:relative;transition-property:transform;transition-timing-function:var(--swiper-wrapper-transition-timing-function,initial);width:100%;z-index:1}.swiper-android ::slotted(swiper-slide),.swiper-ios ::slotted(swiper-slide),.swiper-wrapper{transform:translateZ(0)}.swiper-horizontal{touch-action:pan-y}.swiper-vertical{touch-action:pan-x}::slotted(swiper-slide){display:block;flex-shrink:0;height:100%;position:relative;transition-property:transform;width:100%}::slotted(.swiper-slide-invisible-blank){visibility:hidden}.swiper-autoheight,.swiper-autoheight ::slotted(swiper-slide){height:auto}.swiper-autoheight .swiper-wrapper{align-items:flex-start;transition-property:transform,height}.swiper-backface-hidden ::slotted(swiper-slide){backface-visibility:hidden;transform:translateZ(0)}.swiper-3d.swiper-css-mode .swiper-wrapper{perspective:1200px}.swiper-3d .swiper-wrapper{transform-style:preserve-3d}.swiper-3d{perspective:1200px}.swiper-3d .swiper-cube-shadow,.swiper-3d ::slotted(swiper-slide){transform-style:preserve-3d}.swiper-css-mode>.swiper-wrapper{overflow:auto;scrollbar-width:none;-ms-overflow-style:none}.swiper-css-mode>.swiper-wrapper::-webkit-scrollbar{display:none}.swiper-css-mode ::slotted(swiper-slide){scroll-snap-align:start start}.swiper-css-mode.swiper-horizontal>.swiper-wrapper{scroll-snap-type:x mandatory}.swiper-css-mode.swiper-vertical>.swiper-wrapper{scroll-snap-type:y mandatory}.swiper-css-mode.swiper-free-mode>.swiper-wrapper{scroll-snap-type:none}.swiper-css-mode.swiper-free-mode ::slotted(swiper-slide){scroll-snap-align:none}.swiper-css-mode.swiper-centered>.swiper-wrapper:before{content:"";flex-shrink:0;order:9999}.swiper-css-mode.swiper-centered ::slotted(swiper-slide){scroll-snap-align:center center;scroll-snap-stop:always}.swiper-css-mode.swiper-centered.swiper-horizontal ::slotted(swiper-slide):first-child{margin-inline-start:var(--swiper-centered-offset-before)}.swiper-css-mode.swiper-centered.swiper-horizontal>.swiper-wrapper:before{height:100%;min-height:1px;width:var(--swiper-centered-offset-after)}.swiper-css-mode.swiper-centered.swiper-vertical ::slotted(swiper-slide):first-child{margin-block-start:var(--swiper-centered-offset-before)}.swiper-css-mode.swiper-centered.swiper-vertical>.swiper-wrapper:before{height:var(--swiper-centered-offset-after);min-width:1px;width:100%}',SwiperSlideCSS="::slotted(.swiper-slide-shadow),::slotted(.swiper-slide-shadow-bottom),::slotted(.swiper-slide-shadow-left),::slotted(.swiper-slide-shadow-right),::slotted(.swiper-slide-shadow-top){height:100%;left:0;pointer-events:none;position:absolute;top:0;width:100%;z-index:10}::slotted(.swiper-slide-shadow){background:#00000026}::slotted(.swiper-slide-shadow-left){background-image:linear-gradient(270deg,#00000080,#0000)}::slotted(.swiper-slide-shadow-right){background-image:linear-gradient(90deg,#00000080,#0000)}::slotted(.swiper-slide-shadow-top){background-image:linear-gradient(0deg,#00000080,#0000)}::slotted(.swiper-slide-shadow-bottom){background-image:linear-gradient(180deg,#00000080,#0000)}.swiper-lazy-preloader{animation:swiper-preloader-spin 1s linear infinite;border:4px solid var(--swiper-preloader-color,var(--swiper-theme-color));border-radius:50%;border-top:4px solid #0000;box-sizing:border-box;height:42px;left:50%;margin-left:-21px;margin-top:-21px;position:absolute;top:50%;transform-origin:50%;width:42px;z-index:10}@keyframes swiper-preloader-spin{0%{transform:rotate(0deg)}to{transform:rotate(1turn)}}::slotted(.swiper-slide-shadow-cube.swiper-slide-shadow-bottom),::slotted(.swiper-slide-shadow-cube.swiper-slide-shadow-left),::slotted(.swiper-slide-shadow-cube.swiper-slide-shadow-right),::slotted(.swiper-slide-shadow-cube.swiper-slide-shadow-top){backface-visibility:hidden;z-index:0}::slotted(.swiper-slide-shadow-flip.swiper-slide-shadow-bottom),::slotted(.swiper-slide-shadow-flip.swiper-slide-shadow-left),::slotted(.swiper-slide-shadow-flip.swiper-slide-shadow-right),::slotted(.swiper-slide-shadow-flip.swiper-slide-shadow-top){backface-visibility:hidden;z-index:0}::slotted(.swiper-zoom-container){align-items:center;display:flex;height:100%;justify-content:center;text-align:center;width:100%}::slotted(.swiper-zoom-container)>canvas,::slotted(.swiper-zoom-container)>img,::slotted(.swiper-zoom-container)>svg{max-height:100%;max-width:100%;object-fit:contain}";class DummyHTMLElement{}const ClassToExtend="undefined"==typeof window||"undefined"==typeof HTMLElement?DummyHTMLElement:HTMLElement,addStyle=(e,s)=>{if("undefined"!=typeof CSSStyleSheet&&e.adoptedStyleSheets){const i=new CSSStyleSheet;i.replaceSync(s),e.adoptedStyleSheets=[i]}else{const i=document.createElement("style");i.rel="stylesheet",i.textContent=s,e.appendChild(i)}};class SwiperContainer extends ClassToExtend{constructor(){super(),this.attachShadow({mode:"open"})}cssStyles(){return[SwiperCSS,...this.injectStyles&&Array.isArray(this.injectStyles)?this.injectStyles:[]].join("\n")}cssLinks(){return this.injectStylesUrls||[]}calcSlideSlots(){const e=this.slideSlots||0,s=[...this.querySelectorAll("[slot^=slide-]")].map(e=>parseInt(e.getAttribute("slot").split("slide-")[1],10));if(this.slideSlots=s.length?Math.max(...s)+1:0,this.rendered)if(this.slideSlots>e)for(let s=e;s<this.slideSlots;s+=1){const e=document.createElement("swiper-slide");e.setAttribute("part",`slide slide-${s+1}`);const i=document.createElement("slot");i.setAttribute("name",`slide-${s+1}`),e.appendChild(i),this.shadowRoot.querySelector(".swiper-wrapper").appendChild(e)}else if(this.slideSlots<e){const e=this.swiper.slides;for(let s=e.length-1;s>=0;s-=1)s>this.slideSlots&&e[s].remove()}}render(){if(this.rendered)return;this.calcSlideSlots();let e=this.cssStyles();this.slideSlots>0&&(e=e.replace(/::slotted\(([a-z-0-9.]*)\)/g,"$1")),e.length&&addStyle(this.shadowRoot,e),this.cssLinks().forEach(e=>{if(this.shadowRoot.querySelector(`link[href="${e}"]`))return;const s=document.createElement("link");s.rel="stylesheet",s.href=e,this.shadowRoot.appendChild(s)});const s=document.createElement("div");s.classList.add("swiper"),s.part="container",setInnerHTML(s,`\n      <slot name="container-start"></slot>\n      <div class="swiper-wrapper" part="wrapper">\n        <slot></slot>\n        ${Array.from({length:this.slideSlots}).map((e,s)=>`\n        <swiper-slide part="slide slide-${s}">\n          <slot name="slide-${s}"></slot>\n        </swiper-slide>\n        `).join("")}\n      </div>\n      <slot name="container-end"></slot>\n      ${needsNavigation(this.passedParams)?'\n        <div part="button-prev" class="swiper-button-prev"></div>\n        <div part="button-next" class="swiper-button-next"></div>\n      ':""}\n      ${needsPagination(this.passedParams)?'\n        <div part="pagination" class="swiper-pagination"></div>\n      ':""}\n      ${needsScrollbar(this.passedParams)?'\n        <div part="scrollbar" class="swiper-scrollbar"></div>\n      ':""}\n    `),this.shadowRoot.appendChild(s),this.rendered=!0}initialize(){if(this.swiper&&this.swiper.initialized)return;const{params:e,passedParams:s}=getParams(this);this.swiperParams=e,this.passedParams=s,delete this.swiperParams.init,this.render(),this.swiper=new Swiper(this.shadowRoot.querySelector(".swiper"),{...e.virtual?{}:{observer:!0},...e,touchEventsTarget:"container",onAny:(s,...i)=>{"observerUpdate"===s&&this.calcSlideSlots();const t=e.eventsPrefix?`${e.eventsPrefix}${s.toLowerCase()}`:s.toLowerCase(),r=new CustomEvent(t,{detail:i,bubbles:"hashChange"!==s,cancelable:!0});this.dispatchEvent(r)}})}connectedCallback(){this.swiper&&this.swiper.initialized&&this.nested&&this.closest("swiper-slide")&&this.closest("swiper-slide").swiperLoopMoveDOM||!1!==this.init&&"false"!==this.getAttribute("init")&&this.initialize()}disconnectedCallback(){this.nested&&this.closest("swiper-slide")&&this.closest("swiper-slide").swiperLoopMoveDOM||this.swiper&&this.swiper.destroy&&this.swiper.destroy()}updateSwiperOnPropChange(e,s){const{params:i,passedParams:t}=getParams(this,e,s);this.passedParams=t,this.swiperParams=i,this.swiper&&this.swiper.params[e]===s||updateSwiper({swiper:this.swiper,passedParams:this.passedParams,changedParams:[attrToProp(e)],..."navigation"===e&&t[e]?{prevEl:".swiper-button-prev",nextEl:".swiper-button-next"}:{},..."pagination"===e&&t[e]?{paginationEl:".swiper-pagination"}:{},..."scrollbar"===e&&t[e]?{scrollbarEl:".swiper-scrollbar"}:{}})}attributeChangedCallback(e,s,i){this.swiper&&this.swiper.initialized&&("true"===s&&null===i&&(i=!1),this.updateSwiperOnPropChange(e,i))}static get observedAttributes(){return paramsList.filter(e=>e.includes("_")).map(e=>e.replace(/[A-Z]/g,e=>`-${e}`).replace("_","").toLowerCase())}}paramsList.forEach(e=>{"init"!==e&&(e=e.replace("_",""),Object.defineProperty(SwiperContainer.prototype,e,{configurable:!0,get(){return(this.passedParams||{})[e]},set(s){this.passedParams||(this.passedParams={}),this.passedParams[e]=s,this.swiper&&this.swiper.initialized&&this.updateSwiperOnPropChange(e,s)}}))});class SwiperSlide extends ClassToExtend{constructor(){super(),this.attachShadow({mode:"open"})}render(){const e=this.lazy||""===this.getAttribute("lazy")||"true"===this.getAttribute("lazy");if(addStyle(this.shadowRoot,SwiperSlideCSS),this.shadowRoot.appendChild(document.createElement("slot")),e){const e=document.createElement("div");e.classList.add("swiper-lazy-preloader"),e.part.add("preloader"),this.shadowRoot.appendChild(e)}}initialize(){this.render()}connectedCallback(){this.swiperLoopMoveDOM||this.initialize()}}const register=()=>{"undefined"!=typeof window&&(window.customElements.get("swiper-container")||window.customElements.define("swiper-container",SwiperContainer),window.customElements.get("swiper-slide")||window.customElements.define("swiper-slide",SwiperSlide))};"undefined"!=typeof window&&(window.SwiperElementRegisterParams=e=>{paramsList.push(...e)});export{SwiperContainer,SwiperSlide,register};
//# sourceMappingURL=swiper-element.min.mjs.map