﻿(function ($) {
  $(function () {
    'use strict';

    /* ---------- helper: isOnScreen (jQuery plugin) ---------- */
    $.fn.isOnScreen = function () {
      if (!this.length) return false;
      var win = $(window);
      var viewport = {
        top: win.scrollTop(),
        left: win.scrollLeft()
      };
      viewport.right = viewport.left + win.width();
      viewport.bottom = viewport.top + win.height();

      var bounds = this.offset();
      bounds.right = bounds.left + this.outerWidth();
      bounds.bottom = bounds.top + this.outerHeight();

      return !(
        viewport.right < bounds.left ||
        viewport.left > bounds.right ||
        viewport.bottom < bounds.top ||
        viewport.top > bounds.bottom
      );
    };

    /* ---------- Helper: safe Swiper init that resolves pagination/navigation inside container ---------- */
    function initSwiper(selector, options) {
      if (typeof Swiper === 'undefined') {
        console.warn('Swiper not found — skipping init for', selector);
        return null;
      }
      var container = document.querySelector(selector);
      if (!container) {
        // element not present in DOM
        return null;
      }

      // Clone options to avoid mutating original
      var config = $.extend(true, {}, options);

      // Resolve pagination element if selector provided and is inside container
      if (config.pagination && typeof config.pagination.el === 'string') {
        var pagEl = container.querySelector(config.pagination.el);
        if (pagEl) config.pagination.el = pagEl;
        else delete config.pagination; // remove pagination if not found
      }

      // Resolve navigation buttons (try inside container first, otherwise global)
      if (config.navigation) {
        var nav = {};
        if (config.navigation.nextEl) {
          if (typeof config.navigation.nextEl === 'string') {
            nav.nextEl =
              container.querySelector(config.navigation.nextEl) ||
              document.querySelector(config.navigation.nextEl) ||
              undefined;
          } else {
            nav.nextEl = config.navigation.nextEl;
          }
        }
        if (config.navigation.prevEl) {
          if (typeof config.navigation.prevEl === 'string') {
            nav.prevEl =
              container.querySelector(config.navigation.prevEl) ||
              document.querySelector(config.navigation.prevEl) ||
              undefined;
          } else {
            nav.prevEl = config.navigation.prevEl;
          }
        }
        if (Object.keys(nav).length) config.navigation = nav;
        else delete config.navigation;
      }

      try {
        return new Swiper(container, config);
      } catch (err) {
        console.error('Swiper init failed for', selector, err);
        return null;
      }
    }

    /* ------------------- Swiper inits ------------------- */
    var bannerHome = initSwiper('.bannerHome', {
      speed: 900,
      autoplay: { delay: 6000, disableOnInteraction: false },
      pagination: { el: '.swiper-pagination', clickable: true }
    });

    var servicesListSlider = initSwiper('.servicesListSlider', {
      speed: 900,
      slidesPerView: 4,
      spaceBetween: 48,
      autoplay: { delay: 6000, disableOnInteraction: false },
      pagination: { el: '.servicesPagination', clickable: true },
      navigation: { nextEl: '.nextBtn', prevEl: '.prevBtn' },
      breakpoints: {
        300: { slidesPerView: 2, spaceBetween: 10 },
        480: { slidesPerView: 2, spaceBetween: 10 },
        720: { slidesPerView: 3, spaceBetween: 10 },
        1001: { slidesPerView: 3, spaceBetween: 10 }
      }
    });

    var exportsListSlider = initSwiper('.exportsListSlider', {
      speed: 900,
      slidesPerView: 4,
      spaceBetween: 48,
      autoplay: { delay: 6000, disableOnInteraction: false },
      navigation: { nextEl: '.nextBtn', prevEl: '.prevBtn' },
      breakpoints: {
        300: { slidesPerView: 2, spaceBetween: 10 },
        480: { slidesPerView: 2, spaceBetween: 10 },
        720: { slidesPerView: 3, spaceBetween: 10 },
        1001: { slidesPerView: 3, spaceBetween: 10 }
      }
    });

    var commentListSlider = initSwiper('.commentListSlider', {
      speed: 900,
      slidesPerView: 3,
      spaceBetween: 100,
      effect: 'coverflow',
      grabCursor: true,
      centeredSlides: true,
      autoplay: { delay: 6000, disableOnInteraction: false },
      navigation: { nextEl: '.commentListSliderNxt', prevEl: '.commentListSliderPrev' },
      coverflowEffect: { rotate: 30, stretch: 0, depth: 100, modifier: 1, slideShadows: false },
      breakpoints: {
        300: { slidesPerView: 2, spaceBetween: 10 },
        480: { slidesPerView: 2, spaceBetween: 10 },
        720: { slidesPerView: 3, spaceBetween: 10 }
      }
    });

    var usersSlider = initSwiper('.usersSlider', {
      speed: 900,
      slidesPerView: 3,
      spaceBetween: 56,
      grabCursor: true,
      centeredSlides: true,
      autoplay: { delay: 6000, disableOnInteraction: false },
      navigation: { nextEl: '.usersSlider_nextBtn', prevEl: '.usersSlider_prevBtn' },
      breakpoints: {
        300: { slidesPerView: 1, spaceBetween: 10 },
        480: { slidesPerView: 1, spaceBetween: 10 },
        720: { slidesPerView: 3, spaceBetween: 10 }
      }
    });

    var gallerybottom = initSwiper('.galleryImg_bottom_slider', {
      slidesPerView: 7,
      watchSlidesVisibility: true,
      watchSlidesProgress: true,
      spaceBetween: 16,
      navigation: { nextEl: '.galleryImg_bottom_nextBtn', prevEl: '.galleryImg_bottom_prevBtn' },
       breakpoints: {
        300: { slidesPerView: 4, spaceBetween: 10 },
        480: { slidesPerView: 4, spaceBetween: 10 },
        720: { slidesPerView: 4, spaceBetween: 10 },
      }
    });

    // gallery top must be initialized AFTER gallerybottom (so thumbs work reliably)
    var galleryImgTop = null;
    if (gallerybottom) {
      galleryImgTop = initSwiper('.galleryImg_top_slider', {
        effect: 'coverflow',
        grabCursor: true,
        centeredSlides: true,
        slidesPerView: 1.4,
        spaceBetween: 20,
        coverflowEffect: { rotate: 30, stretch: 0, depth: 200, modifier: 1, slideShadows: true },
        thumbs: { swiper: gallerybottom } // use thumbs sync (safer than manual controller)
      });

      // synchronize clicks and active thumb class
      function setActiveThumb(index) {
        if (!gallerybottom || !gallerybottom.slides) return;
        var slides = Array.from(gallerybottom.slides);
        slides.forEach(function (s, i) {
          if (i === index) s.classList.add('my-active-thumb');
          else s.classList.remove('my-active-thumb');
        });
      }

      // click on bottom thumbs -> top slide
      gallerybottom.on('click', function () {
        var clickedIndex = gallerybottom.clickedIndex;
        if (typeof clickedIndex !== 'undefined' && clickedIndex !== null) {
          if (galleryImgTop) galleryImgTop.slideTo(clickedIndex);
          setActiveThumb(clickedIndex);
        }
      });

      // when top changes -> update thumb active
      if (galleryImgTop) {
        galleryImgTop.on('slideChange', function () {
          setActiveThumb(galleryImgTop.activeIndex);
        });
        // set initial active thumb
        setActiveThumb(galleryImgTop.activeIndex || 0);
      }
    }

    var gallerySlider = initSwiper('.gallerySlider', {
      slidesPerView: 3,
      centeredSlides: true,
      effect: 'coverflow',
      grabCursor: true,
      loop: false,
      spaceBetween: 30,
      speed: 700,
      coverflowEffect: { rotate: -30, stretch: 0, depth: 100, modifier: 1, slideShadows: false },
      pagination: { el: '.galleryPagination', clickable: true },
      navigation: { nextEl: '.gallerySlider_nextBtn', prevEl: '.gallerySlider_prevBtn' },
      autoplay: { delay: 6000, disableOnInteraction: false }
    });

    var InnovationSlider = initSwiper('.InnovationSlider', {
      slidesPerView: 3,
      centeredSlides: true,
      effect: 'coverflow',
      grabCursor: true,
      loop: false,
      spaceBetween: 72,
      speed: 700,
      coverflowEffect: { rotate: -10, stretch: 0, depth: 100, modifier: 1, slideShadows: false },
      pagination: { el: '.InnovationPagination', clickable: true },
      navigation: { nextEl: '.InnovationSlider_nextBtn', prevEl: '.InnovationSlider_prevBtn' },
      autoplay: { delay: 6000, disableOnInteraction: false },
      breakpoints: {
        300: { slidesPerView: 1 },
        480: { slidesPerView: 2 },
        720: { slidesPerView: 3 },
        1001: { slidesPerView: 3 }
      }
    });

    var topSwiper = initSwiper('.swiper-top', {
      slidesPerView: 5,
      spaceBetween: 20,
      navigation: { nextEl: '.insuranceNxt', prevEl: '.insurancePrv' },
      pagination: { el: '.insuranceListPagination', clickable: true },
      breakpoints: {
        300: { slidesPerView: 3 },
        480: { slidesPerView: 3 },
        720: { slidesPerView: 4 },
        1001: { slidesPerView: 5 }
      }
    });

    var bottomSwiper = initSwiper('.swiper-bottom', {
      slidesPerView: 4,
      spaceBetween: 10,
      navigation: { nextEl: '.insuranceNxt', prevEl: '.insurancePrv' },
      pagination: { el: '.insuranceListPagination', clickable: true },
      breakpoints: {
        300: { slidesPerView: 2 },
        480: { slidesPerView: 2 },
        720: { slidesPerView: 3},
        1001: { slidesPerView: 4 }
      }
    });

    var HospitalDepartmentsInfoSlider = initSwiper('.HospitalDepartmentsInfo_slider', {
      speed: 900,
      slidesPerView: 4,
      spaceBetween: 40,
      autoplay: { delay: 6000, disableOnInteraction: false },
      pagination: { el: '.HospitalDepartmentsInfoPagination', clickable: true },
      navigation: { nextEl: '.HospitalDepartmentsInfoNxt', prevEl: '.HospitalDepartmentsInfoPrv' },
      breakpoints: {
        300: { slidesPerView: 1, spaceBetween: 30 },
        480: { slidesPerView: 1, spaceBetween: 30 },
        720: { slidesPerView: 2, spaceBetween: 30 },
        1001: { slidesPerView: 3, spaceBetween: 30 }
      }
    });

    var certificateSlider = initSwiper('.certificateSlider', {
      speed: 900,
      slidesPerView: 5,
      spaceBetween: 10,
      autoplay: { delay: 6000, disableOnInteraction: false },
      pagination: { el: '.servicesPagination', clickable: true },
      navigation: { nextEl: '.certificateSliderNxt', prevEl: '.certificateSliderPrv' },
      breakpoints: {
        300: { slidesPerView: 2, spaceBetween: 10 },
        480: { slidesPerView: 2, spaceBetween: 10 },
        720: { slidesPerView: 3, spaceBetween: 10 }
      }
    });

    var blogCat = initSwiper('.blogCat_slider', {
      speed: 900,
      slidesPerView: 6,
      spaceBetween: 20,
      pagination: { el: '.servicesPagination', clickable: true },
      navigation: { nextEl: '.blogCat_slider-next', prevEl: '.blogCat_slider-prev' },
      breakpoints: {
        300: { slidesPerView: 2, spaceBetween: 10 },
        480: { slidesPerView: 2, spaceBetween: 10 },
        720: { slidesPerView: 3, spaceBetween: 10 },
        1000: { slidesPerView: 4, spaceBetween: 10 },
        1249: { slidesPerView: 5, spaceBetween: 10 },
      }
    });

    var scientificEventsSlider = initSwiper('.scientificEventsSlider', {
      speed: 900,
      slidesPerView: 8,
      spaceBetween: 30,
      navigation: { nextEl: '.scientificEventsSlider-next', prevEl: '.scientificEventsSlider-prev' },
      breakpoints: {
        300: { slidesPerView: 4, spaceBetween: 10 },
        480: { slidesPerView: 4, spaceBetween: 10 },
        720: { slidesPerView: 6, spaceBetween: 10 },
        1249: { slidesPerView: 6, spaceBetween: 10 },
      }
    });

// emojiList
  $('.emojiList li').click(function(){
      $(this).addClass('active').siblings().removeClass('active');
  });
//video

     $('.playBtn').click(function () {
        var thisvideo = $(this).parent().find('video')[0];
        $(this).fadeOut();
        $(this).parent().addClass('show');
        $(this).siblings('video')[0].play();
        $(this).siblings('video').on("ended", function () {
            $(this).parent().find('video')[0].load();
            $('.playBtn').fadeIn();
            $('.playBtn').parent().removeClass('show');
            thisvideo.removeAttribute("controls");
        });
        if (thisvideo.hasAttribute("controls")) { thisvideo.removeAttribute("controls"); }
        else { thisvideo.setAttribute("controls", "controls"); }
    });
    /* ------------------- Map (Leaflet) ------------------- */
    (function initMap() {
      if (typeof L === 'undefined') {
        // Leaflet missing
        console.warn('Leaflet not found; map will not be initialized.');
        return;
      }
      var mapEl = document.getElementById('map');
      if (!mapEl) return;

      try {
        var map = L.map('map').setView([36.35528236449146, 59.54818333881945], 12);
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
          attribution: ''
        }).addTo(map);

        var mapPin = L.icon({
          iconUrl: '/assets/images/marker-icon.png',
          iconSize: [25, 41],
          iconAnchor: [20, 40],
          popupAnchor: [0, -40]
        });

        L.marker([36.35528236449146, 59.54818333881945], { icon: mapPin })
          .addTo(map)
          .bindPopup('ایران، خراسان رضوی، مشهد، بزرگراه پیامبر اعظم، بعد از پل قائم، بیمارستان رضوی');
      } catch (err) {
        console.error('Error initializing map:', err);
      }
    })();

    /* ------------------- virtual tour active item (vanilla) ------------------- */
    (function initVirtualtour() {
      var items = document.querySelectorAll('#virtualtour li');
      if (!items || !items.length) return;
      function setActive(element) {
        items.forEach(function (it) { it.classList.remove('active'); });
        element.classList.add('active');
      }
      items.forEach(function (item) {
        item.addEventListener('mouseover', function () { setActive(item); });
        item.addEventListener('click', function () { setActive(item); });
      });
    })();

    /* ------------------- galleryList active item (vanilla) ------------------- */
    (function initGalleryList() {
      var items = document.querySelectorAll('#galleryList li');
      if (!items || !items.length) return;
      function setActive(element) {
        items.forEach(function (it) { it.classList.remove('active'); });
        element.classList.add('active');
      }
      items.forEach(function (item) {
        item.addEventListener('mouseover', function () { setActive(item); });
        item.addEventListener('click', function () { setActive(item); });
      });
    })();

    /* ------------------- Nav scroll handling ------------------- */
    (function initNav() {
      var navElem = document.getElementById('mainNav');
      if (!navElem) return;

      // initial state depending on presence of .sectionOne
      if ($('.sectionOne').length === 1) {
        navElem.classList.remove('bg-white', 'txt-black');
      } else {
        navElem.classList.add('bg-white', 'txt-black');
      }

      // on scroll toggle classes
      window.addEventListener('scroll', function () {
        var y = window.scrollY || document.documentElement.scrollTop;
        if (y > 0) navElem.classList.add('bg-white', 'txt-black');
        else navElem.classList.remove('bg-white', 'txt-black');
      });
    })();

    /* ------------------- on-screen animations (combine handlers) ------------------- */
    function handleOnScreen() {
      $('.aboutSec_c, .HospitalDepartments_facilities_List').each(function () {
        if ($(this).isOnScreen()) $(this).addClass('active');
        else $(this).removeClass('active');
      });
    }
    // trigger on scroll/resize/load and once on ready
    $(window).on('scroll resize load', handleOnScreen);
    handleOnScreen();

    /* ------------------- cleanup: remove stray/incomplete functions from original code ------------------- */
    // (If you relied on any Fancybox helper that was partially pasted earlier, re-add the official Fancybox script instead of that raw function.)

    /* ------------------- Done ------------------- */
    // If anything هنوز کار نکرد، خطاهای دقیقِ Console (Uncaught ...) رو برام بفرست تا دقیق‌تر رفع کنم.
  });
})(jQuery);
