document.addEventListener('DOMContentLoaded', function () {

  /*** popup ***/
  $('[data-popup]').on('click', function (e) {
    var DataPopUp = $(this).data('popup');
    if (DataPopUp) {
      e.preventDefault();
      $('.bodyglas').addClass('showing');
      $(".popupOverlay." + DataPopUp).addClass("is-active");
    }
  });

  $('.popupOverlay').on('click', function (e) {
    if ($(e.target).hasClass('popupOverlay')) {
      $(this).removeClass('is-active');
      $('.bodyglas').removeClass('showing');
    }
  });

  $('.popup-close').on('click', function (e) {
    e.preventDefault();
    $(this).closest('.popupOverlay').removeClass('is-active');
    $('.bodyglas').removeClass('showing');
  });
  /*** popup end ***/


  /*** tab ***/
  $("[data-tab]").on('click', function (e) {
    e.preventDefault();
    let Href = $(this).attr("href");
    let parentSlide = $(this).closest("[data-Ptab]");
    parentSlide.find("[data-tab]").removeClass("active");
    $(this).addClass("active");
    let parent = $(this).closest("[data-parent]");
    parent.find("[data-Tlist]").removeClass("active");
    parent.find(Href).addClass("active");
  });
  /*** tab end ***/


/*** header scroll toggle ***/
function toggleHeaderClass() {
  let scroll = $(window).scrollTop();

  if (scroll <= 0) {
    $('header').removeClass('bg-white txt-black');
  } else if (scroll > 65) {
    $('header').addClass('bg-white txt-black');
  } else {
    $('header').removeClass('bg-white txt-black');
  }
}

// جلوگیری از حفظ اسکرول در Firefox و مرورگرهای دیگه
if ('scrollRestoration' in history) {
  history.scrollRestoration = 'manual';
}

$(window).on('load', function () {
  window.scrollTo(0, 0);
  $('header').removeClass('bg-white txt-black');
  toggleHeaderClass();
});

$(window).on('scroll', toggleHeaderClass);

/*** header scroll end ***/



  /*** FAQ toggle ***/
  $('.faqListItem_up').on('click', function () {
    $(this).toggleClass('active');
    $(this).siblings('.faqListItem_down').slideToggle();
  });
  /*** FAQ toggle end ***/


  /*** Counter ***/
  $.fn.isOnScreen = function () {
    var win = $(window);
    var viewport = {
      top: win.scrollTop(),
      left: win.scrollLeft()
    };
    viewport.right = viewport.left + win.width();
    viewport.bottom = viewport.top + win.height();

    var bounds = this.offset();
    bounds.right = bounds.left + this.outerWidth();
    bounds.bottom = bounds.top + this.outerHeight();

    return (!(viewport.right < bounds.left ||
      viewport.left > bounds.right ||
      viewport.bottom < bounds.top ||
      viewport.top > bounds.bottom));
  };

  function startCounter(counterElement) {
    if (counterElement.hasClass("notVisible")) {
      counterElement.removeClass("notVisible");

      counterElement.prop('Counter', 0).animate({
        Counter: counterElement.attr("counter-lim")
      }, {
        duration: 4000,
        easing: 'swing',
        step: function (now) {
          counterElement.text(Math.ceil(now).toLocaleString());
        }
      });
    }
  }

  // throttle scroll برای جلوگیری از lag
  let scrollTimeout;
  $(window).on('scroll', function () {
    if (scrollTimeout) clearTimeout(scrollTimeout);
    scrollTimeout = setTimeout(function () {
      $(".count").each(function () {
        if ($(this).isOnScreen()) {
          startCounter($(this));
        } else {
          if (!$(this).hasClass("notVisible")) {
            $(this).stop().addClass("notVisible").text("0");
          }
        }
      });
    }, 50); // هر 50ms یکبار
  });

  // اجرای اولیه برای وقتی که روی صفحه هستن
  $('.count').each(function () {
    $(this).addClass("notVisible");
    if ($(this).isOnScreen()) {
      startCounter($(this));
    }
  });
  /*** Counter end ***/

});
