// src/data/breadcrumbSources.ts

const BASE = process.env.NEXT_PUBLIC_API_BASE!;

export const breadcrumbSources: Record<
  string,
  {
    findFn: (slug: string) => Promise<{
      title?: string;
      name?: string;
      fullName?: string;
      pageTitle?: string;
    } | null>;
  }
> = {
  // ------------------------------
  // 1) Board
  // ------------------------------
  board: {
    findFn: async (slug: string) => {
      try {
        const res = await fetch(
          `${BASE}/BoardOfDirectors/api/v1/fa/board-of-directors/${slug}`,
          { cache: "no-store" }
        );
        const json = await res.json();
        return json?.success ? json.data.pageInfo : null;
      } catch {
        return null;
      }
    },
  },

  // ------------------------------
  // 2) Doctors
  // ------------------------------
  doctors: {
    findFn: async (slug: string) => {
      try {
        const res = await fetch(
          `${BASE}/Doctors/api/v1/fa/doctors/${slug}`,
          { cache: "no-store" }
        );
        const json = await res.json();
        return json?.success ? json.data : null;
      } catch {
        return null;
      }
    },
  },
 // ------------------------------
  // 2) Department
  departmans: {
  findFn: async (slug: string) => {
    try {
      const res = await fetch(
        `${BASE}/Departments/api/v1/fa/department/${slug}`,
        { cache: "no-store" }
      );
      const json = await res.json();
      return json?.success ? json.data.pageInfo : null;
    } catch {
      return null;
    }
  },
},
  // ------------------------------

  // ------------------------------
news: {
  findFn: async (slug: string) => {
    try {
      const res = await fetch(
        `${BASE}/Blogs/api/v1/fa/blog/${slug}`,
        { cache: "no-store" }
      );
      const json = await res.json();

      if (json?.success && json?.data?.pageInfo) {
        const p = json.data.pageInfo;
        return {
          title: p.title || p.pageTitle || p.ogTitle || slug,
          pageTitle: p.pageTitle || p.title,
        };
      }

      return null;
    } catch {
      return null;
    }
  },
},


newsCategory: {
  findFn: async (slug: string) => {
    try {
      const res = await fetch(
        `${BASE}/Blogs/api/v1/fa/blog-list/${slug}?page=1`,
        { cache: "no-store" }
      );
      const json = await res.json();

      if (json?.success && json?.data?.pageInfo) {
        const p = json.data.pageInfo;
        return {
          title: p.title || p.pageTitle || p.ogTitle || slug,
          pageTitle: p.pageTitle || p.title,
        };
      }

      return null;
    } catch {
      return null;
    }
  },
},



  // ------------------------------

  // ------------------------------
  education: {
    findFn: async (slug: string) => {
      try {
        const res = await fetch(
          `${BASE}/Tutorials/api/v1/fa/tutorial/${slug}`,
          { cache: "no-store" }
        );
        const json = await res.json();
        return json?.success ? json.data.pageInfo : null;
      } catch {
        return null;
      }
    },
  },
 educationCategory: {
    findFn: async (slug: string) => {
      try {
        const res = await fetch(
          `${BASE}/Tutorials/api/v1/fa/tutorial-list/${slug}`,
          { cache: "no-store" }
        );
        const json = await res.json();
        return json?.success ? json.data.pageInfo : null;
      } catch {
        return null;
      }
    },
  },

  // ------------------------------
  //Gallery
  // ------------------------------
  gallery: {
    findFn: async (slug: string) => {
      try {
        const res = await fetch(
          `${BASE}/Gallery/api/v1/fa/gallery/${slug}`,
          { cache: "no-store" }
        );
        const json = await res.json();

        if (json?.success) {
          return {
            title: json.data.title || json.data.pageInfo?.title,
          };
        }
        return null;
      } catch {
        return null;
      }
    },
  },

  galleryCategory: {
    findFn: async (slug: string) => {
      try {
        const res = await fetch(
          `${BASE}/Gallery/api/v1/fa/gallery-list/${slug}?page=1`,
          { cache: "no-store" }
        );
        const json = await res.json();

        return json?.success
          ? { title: json.data.pageInfo.title }
          : null;
      } catch {
        return null;
      }
    },
  },
};
