import type { HeaderData } from "@/src/types/header";

export const mockHeaderData: HeaderData = {
  logoMain: "/images/logoMain.svg",
  logoSecondary: "/images/logoNew.svg",
  title: "بیمارستان فوق تخصصی رضوی",
  subtitle: "Razavi Superspecialty Hospital",

  // 🌐 زبان‌ها
  languages: [
    { name: "English", code: "en", flag: "/images/UKFlag.png", href: "#" },
    { name: "العربية", code: "ar", flag: "/images/ArabFlag.png", href: "#" },
    { name: "Русский", code: "ru", flag: "/images/RussiaFlag.png", href: "#" },
  ],

  // 📅 نوبت‌دهی
  appointmentMenu: [
    { title: "راهنمای نوبت دهی آنلاین", href: "#" },
    { title: "نوبت دهی کلینیک‌ها", href: "#" },
    { title: "نوبت دهی پاراکلینیک‌ها", href: "#" },
    { title: "پیگیری نوبت", href: "#" },
    { title: "پیش پذیرش بستری", href: "#" },
    { title: "ثبت‌نام چک‌آپ", href: "#" },
    { title: "جواب‌دهی آنلاین", href: "#" },
  ],

  // 🍔 منوی اصلی (سازگار با API)
  mainMenu: [
    {
      id: "home",
      title: "صفحه اصلی",
      url: "/",
      isInternal: true,
      target: "_self",
    },
    {
      id: "about",
      title: "درباره ما",
      url: "/about-us",
      isInternal: true,
      target: "_self",
      children: [
        { id: "board", title: "هیئت مدیره", url: "/about/board" },
        { id: "history", title: "تاریخچه", url: "/about/history" },
        { id: "vision", title: "چشم‌انداز", url: "/about/vision" },
      ],
    },
    {
      id: "doctors",
      title: "پزشکان",
      url: "/doctors",
      isInternal: true,
      target: "_self",
      children: [
        { id: "all-doctors", title: "همه پزشکان", url: "/doctors" },
        { id: "departments", title: "بخش‌های درمانی", url: "/departmans" },
      ],
    },
    {
      id: "education",
      title: "آموزش به بیمار",
      url: "/education",
      isInternal: true,
      target: "_self",
    },
    {
      id: "contact",
      title: "تماس با ما",
      url: "/contact",
      isInternal: true,
      target: "_self",
    },
  ],
};
