"use client";

import { useState, useEffect } from "react";

export default function useOnScreen(
  ref: React.RefObject<Element | null>,
  threshold = 0.1,
  rootMargin = "0px"
): boolean {
  const [isVisible, setIsVisible] = useState(false);

  useEffect(() => {
    const node = ref.current;
    if (!node) return;

    const observer = new IntersectionObserver(
      ([entry]) => setIsVisible(entry.isIntersecting),
      { threshold, rootMargin }
    );

    observer.observe(node);

    return () => observer.disconnect();
  }, []);

  return isVisible;
}

