import type { MissionApiResponse, MissionApiPageInfo } from "@/src/types/mission";

export async function getMissionPage(): Promise<MissionApiPageInfo | null> {
  const endpoint = `${process.env.NEXT_PUBLIC_API_BASE}/Pages/api/v1/fa/page/mission`;

  const res = await fetch(endpoint, { cache: "no-store" });
  if (!res.ok) return null;

  const json: MissionApiResponse = await res.json();
  return json.data?.pageInfo || null;
}
