import type { AboutPageData } from "@/src/types/about";

export async function getAboutPage(): Promise<AboutPageData | null> {
  try {
    const base = process.env.NEXT_PUBLIC_API_BASE;
    const res = await fetch(`${base}/Pages/api/v1/fa/page/about-us`, {
      cache: "no-store",
    });

    if (!res.ok) {
      console.error("❌ Failed to fetch AboutPage:", res.status);
      return null;
    }

    const json = await res.json();

    if (json?.success && json?.data) {
      return json.data as AboutPageData;
    } else {
      console.error("❌ API response invalid:", json);
      return null;
    }
  } catch (error) {
    console.error("❌ Error fetching AboutPage:", error);
    return null;
  }
}
