import type { BoardMembersPageData } from "@/app/(sections)/about/board/types/boardMembers";

export async function getBoardMembersPage(): Promise<BoardMembersPageData> {
  const endpoint = `${process.env.NEXT_PUBLIC_API_BASE}/BoardOfDirectors/api/v1/fa/board-of-directors`;

  const res = await fetch(endpoint, { cache: "no-store" });
  if (!res.ok) throw new Error("خطا در دریافت اطلاعات صفحه اعضای هیئت مدیره");

  const json = await res.json();
  if (!json?.data) throw new Error("داده‌ای از API دریافت نشد");

  const data = json.data;

  return {
    pageInfo: {
      title: data.pageInfo.title,
      content: data.pageInfo.content,
      picture: data.pageInfo.picture,
      pageTitle: data.pageInfo.pageTitle,
      pageDescription: data.pageInfo.pageDescription,
      pageRobotsStatus: data.pageInfo.pageRobotsStatus,
      ogTitle: data.pageInfo.ogTitle,
      ogDescription: data.pageInfo.ogDescription,
      ogImage: data.pageInfo.ogImage,
      slug: data.pageInfo.slug,
      canonical: data.pageInfo.canonical,
    },

    boardMembers: data.items.map((item: any) => ({
      fullName: item.fullName,
      position: item.position,
      picture: item.picture,
      slug: item.slug,
    })),
  };
}
