const base = process.env.NEXT_PUBLIC_API_BASE;
if (!base) throw new Error("NEXT_PUBLIC_API_BASE تعریف نشده است");


export async function getBoardMember(slug: string) {
  const url = `${base}/BoardOfDirectors/api/v1/fa/board-of-directors/${slug}`;

  const res = await fetch(url, { cache: "no-cache" });

  if (!res.ok) {
    console.error("❌ خطا در دریافت دیتا:", res.status);
    return null;
  }

  const json = await res.json();
  return json?.data || null;
}
