import type { CertificatesPageData, CertificateItem } from "@/src/types/certificate";

export async function getCertificatesPage(): Promise<CertificatesPageData> {
  const endpoint = `${process.env.NEXT_PUBLIC_API_BASE}/Pages/api/v1/fa/page/certificates`;

  const res = await fetch(endpoint, { cache: "no-store" });
  if (!res.ok) throw new Error("Error fetching certificates");

  const json = await res.json();
  const data = json.data;

  const certificates: CertificateItem[] = data.certificates.map(
    (item: any, i: number) => ({
      id: String(i + 1),
      title: item.title,
      picture: item.picture
    })
  );

  return {
    title: data.pageInfo.title,
    certificates,
    seo: {
      pageTitle: data.pageInfo.pageTitle,
      pageDescription: data.pageInfo.pageDescription,
      ogTitle: data.pageInfo.ogTitle,
      ogDescription: data.pageInfo.ogDescription,
      ogImage: data.pageInfo.ogImage,
      canonical: data.pageInfo.canonical,
      robots: data.pageInfo.pageRobotsStatus,
    }
  };
}
