import type { CmsPage, CmsPageApiResponse } from "@/src/types/cmsPage";

export async function getCmsPage(slug: string): Promise<CmsPageApiResponse | null> {
  const endpoint = `${process.env.NEXT_PUBLIC_API_BASE}/Pages/api/v1/fa/page/${slug}`;
    console.log("🔥 CMS API called:", slug);
  const res = await fetch(endpoint, { cache: "no-store" });

  if (!res.ok) {
    console.error("❌ CMS API error:", res.status);
    return null;
  }

  const json = await res.json();

  if (!json?.data?.pageInfo) {
    console.error("❌ Invalid CMS response:", json);
    return null;
  }

  return json.data.pageInfo as CmsPageApiResponse;
}
