import type {
  ContactPageData,
  ContactInfo,
  SocialLink,
  DepartmentContact,
  ContactMapInfo
} from "@/src/types/contact";

export async function getContactPage(): Promise<ContactPageData> {
  const endpoint = `${process.env.NEXT_PUBLIC_API_BASE}/Pages/api/v1/fa/page/contact-us`;

  const res = await fetch(endpoint, { cache: "no-store" });
  if (!res.ok) throw new Error("خطا در دریافت اطلاعات تماس");

  const json = await res.json();
  const data = json.data;

  // ---- Contact info ----
  const contactInfo = data.contactInfoSection.contactInfo;

  const infos: ContactInfo[] = [
    {
      id: "address",
      label: "آدرس بیمارستان",
      type: "address",
      values: [contactInfo.address]
    },
    {
      id: "primaryPhone",
      label: "شماره تماس",
      type: "phone",
      values: [contactInfo.primaryPhone, contactInfo.operatorDirectPhone]
    },
    {
      id: "fax",
      label: "فکس",
      type: "fax",
      values: [contactInfo.fax]
    },
    {
      id: "email",
      label: "ایمیل",
      type: "email",
      values: [contactInfo.email]
    },
    {
      id: "time",
      label: "ساعات کار",
      type: "time",
      values: [contactInfo.workingHours]
    }
  ];

  // ---- Map info ----
  const mapInfo: ContactMapInfo = {
    latitude: contactInfo.latitude,
    longitude: contactInfo.longitude,
    neshanUrlNavigation: contactInfo.neshanUrlNavigation,
    googleMapUrlNavigation: contactInfo.googleMapUrlNavigation,
    wazeUrlNavigation: contactInfo.wazeUrlNavigation
  };

  // ---- Social networks ----
  const socials: SocialLink[] = data.contactInfoSection.socialNetworks.map(
    (item: any, i: number) => ({
      id: String(i),
      icon: item.icon,
      url: item.url
    })
  );

  // ---- Departments ----
  const departments: DepartmentContact[] =
    data.contactInfoDepartmentsSection.items.map((item: any, i: number) => ({
      id: String(i),
      icon: item.icon,
      title: item.title,
      phone: item.phone
    }));

  return {
    title: data.formSection.title,
    description: data.formSection.description,
    infos,
    socials,
    departments,
    mapInfo
  };
}
