// src/lib/departmentsApi.ts
import { DepartmentApiResponse, DepartmentData } from "@/src/types/department";

const API_BASE = process.env.NEXT_PUBLIC_API_BASE;

if (!API_BASE) {
  console.warn("NEXT_PUBLIC_API_BASE is not defined");
}

export async function getDepartmentBySlug(slug: string): Promise<DepartmentData> {
  if (!API_BASE) {
    throw new Error("API base url is not defined (NEXT_PUBLIC_API_BASE).");
  }

  const url = `${API_BASE}/Departments/api/v1/fa/department/${slug}`;

  const res = await fetch(url, {
    cache: "no-store",
  });

  if (!res.ok) {
    throw new Error(`Failed to fetch department: ${res.status} ${res.statusText}`);
  }

  const json: DepartmentApiResponse = await res.json();

  if (!json.success || !json.data) {
    throw new Error(json.message || "Failed to load department data");
  }

  return json.data;
}
