import type { DoctorDetailData } from "@/app/(sections)/doctors/types/doctorDetail";

export async function getDoctorDetail(slug: string): Promise<DoctorDetailData> {
  const base = process.env.NEXT_PUBLIC_API_BASE;
  if (!base) throw new Error("NEXT_PUBLIC_API_BASE تعریف نشده است");

  const url = `${base}/Doctors/api/v1/fa/doctors/${slug}`;

  const res = await fetch(url, { cache: "no-store" });
  if (!res.ok) {
    throw new Error("خطا در دریافت اطلاعات پزشک");
  }

  const json = await res.json();
  const data = json.data;

  return {
    pageInfo: {
      id: data.pageInfo.id,
      fullName: data.pageInfo.fullName,
      content: data.pageInfo.content,
      picture: data.pageInfo.picture,
      expertise: data.pageInfo.expertise,
      pageTitle: data.pageInfo.pageTitle,
      pageDescription: data.pageInfo.pageDescription,
      pageRobotsStatus: data.pageInfo.pageRobotsStatus,
      ogTitle: data.pageInfo.ogTitle,
      ogDescription: data.pageInfo.ogDescription,
      ogImage: data.pageInfo.ogImage,
      slug: data.pageInfo.slug,
      canonical: data.pageInfo.canonical,
    },

    comments: (data.comments ?? []).map((c: any) => ({
      id: c.id,
      fullName: c.fullName,
      rate: c.rate,
      comment: c.comment,
      createDate: c.createDate,
    })),
  };
}
