import type { DoctorCard, DoctorListData } from "@/app/(sections)/doctors/types/doctors";

export async function getDoctorsList(
  page: number = 1,
  name?: string,
  expertiseId?: string,
  departmentId?: string
): Promise<{
  pageInfo: DoctorListData["pageInfo"];
  items: DoctorCard[];
  pagination: DoctorListData["pagination"];
}> {
  const base = process.env.NEXT_PUBLIC_API_BASE;
  if (!base) throw new Error("NEXT_PUBLIC_API_BASE تعریف نشده است");

  const params = new URLSearchParams();
  params.set("page", String(page));

  if (name) params.set("name", name);
  if (expertiseId) params.set("expertiseId", expertiseId);
  if (departmentId) params.set("departmentId", departmentId);

  const url = `${base}/Doctors/api/v1/fa/doctors?${params.toString()}`;

  const res = await fetch(url, { cache: "no-store" });
  if (!res.ok) throw new Error("خطا در دریافت لیست پزشکان");

  const json = await res.json();
  const data = json.data;

  return {
    pageInfo: data.pageInfo,

    items: data.doctors.items.map((d: any) => ({
      id: d.id,
      name: d.fullName,
      image: d.picture,
      slug: d.url,
      rate: d.rate,
      specialty: d.expertise ?? "",
    })),

    pagination: {
      totalCount: data.doctors.totalCount,
      pageNumber: data.doctors.pageNumber,
      pageSize: data.doctors.pageSize,
      totalPages: data.doctors.totalPages,
      hasPreviousPage: data.doctors.hasPreviousPage,
      hasNextPage: data.doctors.hasNextPage,
    },
  };
}
