const base = process.env.NEXT_PUBLIC_API_BASE;
if (!base) throw new Error("❌ NEXT_PUBLIC_API_BASE تعریف نشده است");

export async function getDoctor(slug: string) {
  try {
    const res = await fetch(`${base}/Doctors/api/v1/fa/doctors/${slug}`, {
      cache: "no-store",
    });

    if (!res.ok) return null;

    const json = await res.json();
    return json?.data?.pageInfo || null;

  } catch (error) {
    console.error("❌ Error fetching doctor:", error);
    return null;
  }
}
