import type { FacilitiesPageData } from "@/app/(sections)/facilities/types/facilities";

export async function getFacilitiesPage(): Promise<FacilitiesPageData> {
  const endpoint = `${process.env.NEXT_PUBLIC_API_BASE}/Pages/api/v1/fa/page/facilities`;

  const res = await fetch(endpoint, { cache: "no-store" });
  if (!res.ok) throw new Error("خطا در دریافت امکانات");

  const json = await res.json();
  const data = json.data;

  return {
    pageInfo: {
      title: data.pageInfo.title,
      content: data.pageInfo.content,
      picture: data.pageInfo.picture,
      pageTitle: data.pageInfo.pageTitle,
      pageDescription: data.pageInfo.pageDescription,
      pageRobotsStatus: data.pageInfo.pageRobotsStatus,
      ogTitle: data.pageInfo.ogTitle,
      ogDescription: data.pageInfo.ogDescription,
      ogImage: data.pageInfo.ogImage,
      slug: data.pageInfo.slug,
      canonical: data.pageInfo.canonical,
    },

    facilities: data.items.map((item: any) => ({
      title: item.title,
      content: item.content,
      picture: item.picture,
    })),
  };
}
