import type { GalleryListData } from "@/app/(sections)/gallery/types/gallery";

export async function getGalleryList(
  page: number = 1,
  category?: string
): Promise<GalleryListData> {
  const base = process.env.NEXT_PUBLIC_API_BASE;

  const url =
  `${base}/Gallery/api/v1/fa/gallery?page=${page}&pageSize=12` +
  (category ? `&category=${category}` : "");

  const res = await fetch(url, { cache: "no-store" });
  if (!res.ok) throw new Error("خطا در دریافت لیست گالری");

  const json = await res.json();
  const data = json?.data;

  const galleries = data?.galleries;

  return {
    pageInfo: {
      title: data?.pageInfo?.pageTitle || "",
      description: data?.pageInfo?.pageDescription || "",
      canonical: data?.pageInfo?.canonical || "",
      ogTitle: data?.pageInfo?.ogTitle || "",
      ogDescription: data?.pageInfo?.ogDescription || "",
      ogImage: data?.pageInfo?.ogImage || "",
      pageRobotsStatus: data?.pageInfo?.pageRobotsStatus || "",
    },

    categories: data?.categories || [],

    items: Array.isArray(galleries?.items)
      ? galleries.items.map((g: any) => ({
          title: g.title,
          picture: g.picture,
          slug: g.slug,
        }))
      : [],

    pagination: {
      pageNumber: galleries?.pageNumber ?? 1,
      pageSize: galleries?.pageSize ?? 12,
      totalPages: galleries?.totalPages ?? 1,
      totalCount: galleries?.totalCount ?? 0,
      hasNextPage: galleries?.hasNextPage ?? false,
      hasPreviousPage: galleries?.hasPreviousPage ?? false,
    },
  };
}
