import type { GalleryDetailData } from "@/app/(sections)/gallery/types/galleryDetail";

export async function getGalleryDetail(slug: string): Promise<GalleryDetailData> {
  const base = process.env.NEXT_PUBLIC_API_BASE;

  if (!base) {
    throw new Error("NEXT_PUBLIC_API_BASE تعریف نشده است");
  }

  const url = `${base}/Gallery/api/v1/fa/gallery/${slug}`;

  const res = await fetch(url, { cache: "no-store" });

  if (!res.ok) {
    console.error("Gallery detail error:", res.status, res.statusText);
    throw new Error("خطا در دریافت جزئیات گالری");
  }

  const json = await res.json();
  const data = json?.data;

  if (!data) {
    throw new Error("داده‌ای برای این گالری یافت نشد");
  }

  const pageInfo = data.pageInfo || {};

  return {
    pageInfo: {
      title: pageInfo.pageTitle || "",
      description: pageInfo.pageDescription || "",
      content: pageInfo.content || "",
      picture: pageInfo.picture || "",
      canonical: pageInfo.canonical || "",
      ogTitle: pageInfo.ogTitle || "",
      ogDescription: pageInfo.ogDescription || "",
      ogImage: pageInfo.ogImage || "",
      robots: pageInfo.pageRobotsStatus || "",
    },

    items: Array.isArray(data.items)
      ? data.items.map((i: any) => ({
          title: i.title,
          picture: i.picture,
          hasVideo: i.hasVideo,
          video: i.video,
        }))
      : [],
  };
}
