export async function getTutorialDetail(slug: string) {
  try {
    const base = process.env.NEXT_PUBLIC_API_BASE;
    const endpoint = `${base}/Tutorials/api/v1/fa/tutorial/${encodeURIComponent(slug)}`;

    const res = await fetch(endpoint, { cache: "no-store" });

    if (!res.ok) return null;

    const json = await res.json();

    return json.data;
  } catch (error) {
    console.error("Tutorial detail API error:", error);
    return null;
  }
}
