import type {
  TutorialsListResponse,
  TutorialMostViewedItem,
  TutorialCategory,
  TutorialNewestItem,
} from "@/src/types/tutorials";

export async function getTutorialsList(): Promise<TutorialsListResponse | null> {
  try {
    const base = process.env.NEXT_PUBLIC_API_BASE;
    const res = await fetch(`${base}/Tutorials/api/v1/fa/tutorials`, {
      cache: "no-store",
    });

    if (!res.ok) return null;

    const json = await res.json();
    const d = json.data;

    return {
      pageInfo: d.pageInfo,

      mostViewed: d.mostViewersSection?.map(
        (m: any): TutorialMostViewedItem => ({
          title: m.title,
          slug: m.slug,
          picture: m.picture,
          publishedDate: m.publishedDate,
          summary: m.summary,
        })
      ) ?? [],

      newestCategories:
        d.newestSection?.categories?.map(
          (c: any): TutorialCategory => ({
            title: c.title,
            slug: c.slug,
          })
        ) ?? [],

      newest:
        d.newestSection?.newest?.map(
          (n: any): TutorialNewestItem => ({
            title: n.title,
            slug: n.slug,
            picture: n.picture,
            publishedDate: n.publishedDate,
            timeStudy: n.timeStudy,
            summary: n.summary,
          })
        ) ?? [],
    };
  } catch (error) {
    console.error("Tutorials API Error:", error);
    return null;
  }
}
