import type { HeaderApiResponse, MenuItem } from "@/src/types/header";

export async function getHeaderMenu(): Promise<MenuItem[]> {
  const API_BASE = process.env.NEXT_PUBLIC_API_BASE?.replace(/\/$/, "");
  const endpoint = `${API_BASE}/Menu/api/v1/fa/header-links`;

  try {
    const res = await fetch(endpoint, { next: { revalidate: 3600 } });

    if (!res.ok) {
      if (process.env.NODE_ENV === "development")
        console.error(`❌ Header API error: ${res.status}`);
      return [];
    }

    const json: HeaderApiResponse = await res.json();

    if (process.env.NODE_ENV === "development") {
      console.log(`✅ Header API: ${json.data?.links?.length || 0} links`);
    }

    return json?.data?.links ?? [];
  } catch (error) {
    if (process.env.NODE_ENV === "development")
      console.error("❌ Error fetching header menu:", error);
    return [];
  }
}
