import type { HistoryPageData } from "@/src/types/historyPage";

export async function getHistoryPage(): Promise<HistoryPageData> {
  const endpoint = `${process.env.NEXT_PUBLIC_API_BASE}/Pages/api/v1/fa/page/history`;

  const res = await fetch(endpoint, { cache: "no-store" });
  if (!res.ok) throw new Error("API Error");

  const json = await res.json();
  return json.data;
}
