// src/lib/newsApi.ts

import type { NewsApiResponse } from "@/src/types/news";

export async function getNewsPage() {
  const endpoint = `${process.env.NEXT_PUBLIC_API_BASE}/Blogs/api/v1/fa/blog`;

  const res = await fetch(endpoint, { cache: "no-store" });
  if (!res.ok) return null;

  const json: NewsApiResponse = await res.json();
  return json.data;
}
