import type { ContactFormRequest, ContactFormResponse } from "@/src/types/contact";

export async function sendContactForm(
  data: ContactFormRequest
): Promise<ContactFormResponse> {
  const endpoint = `${process.env.NEXT_PUBLIC_API_BASE}/Pages/api/v1/fa/page/contact-us/form`;

  const res = await fetch(endpoint, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      accept: "*/*",
    },
    body: JSON.stringify(data),
  });

  if (!res.ok) {
    throw new Error("Failed to send contact form");
  }

  return res.json();
}
