import type { TariffsApiResponse, TariffsPageData } from "@/src/types/tariffs";

export async function getTariffsPage(): Promise<TariffsPageData | null> {
  const endpoint = `${process.env.NEXT_PUBLIC_API_BASE}/Pages/api/v1/fa/page/tariffs`;

  const res = await fetch(endpoint, { cache: "no-store" });
  if (!res.ok) return null;

  const json: TariffsApiResponse = await res.json();

  const p = json.data.pageInfo;

  return {
    title: p.title,
    image: p.picture || "",
    content: p.content || "",

    categories: json.data.categoriesSection?.items?.map(c => ({
      title: c.title,
      slug: c.slug
    })) || [],

    tariffs: json.data.tariffSection?.items?.map(group => ({
      title: group.title || "",

      items: group.items.map(item => ({
        title: item.title || "",
        description: item.description || "",
      }))
    })) || []
  };
}
