export async function getTrainingDetails(slug: string) {
  const endpoint = `${process.env.NEXT_PUBLIC_API_BASE}/Tutorials/api/v1/fa/tutorials`;

  const res = await fetch(endpoint, { cache: "no-store" });
  if (!res.ok) return null;

  const json = await res.json();

  return {
    title: json.data.title,
    date: json.data.date,
    image: json.data.image,
    readTime: json.data.readTime,
    contentHtml: json.data.content,
    related: json.data.related || [],
  };
}
