import type { VisionApiResponse, VisionApiPageInfo } from "@/src/types/vision";

export async function getVisionPage(): Promise<VisionApiPageInfo | null> {
  const endpoint = `${process.env.NEXT_PUBLIC_API_BASE}/Pages/api/v1/fa/page/vision`;

  const res = await fetch(endpoint, { cache: "no-store" });
  if (!res.ok) return null;

  const json: VisionApiResponse = await res.json();
  return json.data?.pageInfo || null;
}
