// (PageInfo)
export type PageInfo = {
  title: string;  
  content: string;  
  picture: string;         
  pageTitle: string;          
  pageDescription: string;     
  pageRobotsStatus: string;   
  ogTitle: string;           
  ogDescription: string;       
  ogImage: string;            
  slug: string;             
  canonical: string;       
};

//  (History)
export interface HistoryItem {
  title: string;
  description: string;
  year: string;
}

export interface HistorySection {
  title: string;
  description: string;
  items: HistoryItem[];
}

export interface HistoryPageData {
  pageInfo: PageInfo;
  historySection: HistorySection;
}

export interface HistoryApiResponse {
  success: boolean;
  message: string;
  data: HistoryPageData;
}

// (CEO)
export type CeoSection = {
  title: string;
  description: string;
  picture: string;
};

// (Innovation)
export type InnovationItem = {
  title: string;
  description: string;
  picture: string;
};

export type InnovationSection = {
  title: string;
  description: string;
  items: InnovationItem[];
};

//(About)
export type AboutPageData = {
  pageInfo: PageInfo;
  historySection: HistorySection;
  ceoSection: CeoSection;
  innovationSection: InnovationSection;
};

//(Mission)
export interface MissionPageData {
  title: string;
  image: string;
  descriptionTitle: string;
  description: string;
  items: {
    id: number;
    title: string;
    content: string;
  }[];
}

//(Board)
export interface BoardRecord {
  title: string;
  description: string;
}

export interface BoardContact {
  phone?: string;
  email?: string;
}

export interface BoardMember {
  slug: string;
  name: string;
  role: string;
  image: string;
  detailImage: string;
  description: string;
  records: BoardRecord[];
  contact?: BoardContact;
}

//(Vision)
export interface VisionPageData {
  id: string;        
  title: string;  
  image: string;             
  descriptionTitle?: string;   
  description: string;         
}
