// Contact Information
export type ContactInfo = {
  id: string;
  label: string;
  type: "address" | "phone" | "email" | "fax" | "time" | "other";
  values: string[];
};

// Social Media
export type SocialLink = {
  id: string;
  icon: string;
  url: string;
};

// Demartmans
export type DepartmentContact = {
  id: string;
  icon: string;
  title: string;
  phone: string;
};

// Map
export interface ContactMapInfo {
  latitude: string;
  longitude: string;
  neshanUrlNavigation: string;
  googleMapUrlNavigation: string;
  wazeUrlNavigation: string;
}

// main Data
export type ContactPageData = {
  title: string;
  description: string;
  infos: ContactInfo[];
  socials: SocialLink[];
  departments: DepartmentContact[];
  mapInfo: ContactMapInfo;
};

// Contact Form
export interface ContactFormRequest {
  fullName: string;
  email: string;
  phone: string;
  subject: string;
  message: string;
}

export interface ContactFormResponse {
  success: boolean;
  message: string;
  data: string; // UUID returned from backend
}
