// src/types/department.ts

export interface DepartmentPageInfo {
  title: string;
  pageTitle: string;
  pageDescription: string | null;
  pageRobotsStatus: string | null;
  ogTitle: string | null;
  ogDescription: string | null;
  ogImage: string | null;
  slug: string;
  canonical: string | null;
}

export interface DepartmentPresentationSection {
  title: string;
  picture: string | null;
  departmentName: string | null;
  activityType: string | null;
  physicalLocation: string | null;
  establishedDate: string | null;
  purpose: string | null;
  contactNumber: string | null;
  contactHours: string | null;
  contactPerson: string | null;
}

export interface DepartmentServiceItem {
  title: string;
  picture: string | null;
}

export interface DepartmentServiceSection {
  picture: string | null;
  generalServiceDescription: string | null;
  targetPatientGroup: string[];           
  items: DepartmentServiceItem[];
}

export interface DepartmentSpecialServiceItem {
  title: string;
  description: string | null;
}

export interface DepartmentSpecialServicesSection {
  items: DepartmentSpecialServiceItem[];
}

export interface DepartmentPreparationStepItem {
  step: string;
  title: string;
  picture: string | null;
  description: string | null;
}

export interface DepartmentPreparationStepsSection {
  items: DepartmentPreparationStepItem[];
}

export interface DepartmentFacilitiesItem {
  title: string;
  picture: string | null;
  description: string | null;
}

export interface DepartmentFacilitiesAndEquipmentsSection {
  items: DepartmentFacilitiesItem[];
}

export interface DepartmentDoctorItem {
  fullName: string;
  picture: string | null;
  expertise: string | null;
  slug: string;
}

export interface DepartmentDoctorsSection {
  items: DepartmentDoctorItem[];
}

export interface DepartmentServicesAndSchedulingSection {
  picture: string | null;
  workingHours: string | null;
  visitingHours: string | null;
  receiveServiceMethods: string | null;
  internalContactAddress: string | null;
}

export interface DepartmentTermItem {
  title: string;
  description: string | null;
}

export interface DepartmentTermsSection {
  items: DepartmentTermItem[];
}

export interface DepartmentGalleryItem {
  picture: string | null;
}

export interface DepartmentGallerySection {
  items: DepartmentGalleryItem[];
}

export interface DepartmentFaqItem {
  title: string;
  description: string | null;
}

export interface DepartmentFaqsSection {
  items: DepartmentFaqItem[];
}

export interface DepartmentRoutingSection {
  video: string | null;
  nearestPrayerRoom: string | null;
  nearestRestroom: string | null;
  mobileChargingStation: string | null;
  nearestCafeteria: string | null;
  atmOrBankBooth: string | null;
  nearestParkingOrTaxi: string | null;
}

export interface DepartmentData {
  pageInfo: DepartmentPageInfo;
  presentationSection: DepartmentPresentationSection;
  serviceSection: DepartmentServiceSection;
  specialServicesSection: DepartmentSpecialServicesSection;
  preparationSteps: DepartmentPreparationStepsSection;
  facilitiesAndEquipmentsSection: DepartmentFacilitiesAndEquipmentsSection;
  doctorsSection: DepartmentDoctorsSection;
  servicesAndSchedulingSection: DepartmentServicesAndSchedulingSection;
  termsSection: DepartmentTermsSection;
  gallerySection: DepartmentGallerySection;
  faqsSection: DepartmentFaqsSection;
  routingSection: DepartmentRoutingSection;
}

export interface DepartmentApiResponse {
  success: boolean;
  message: string;
  data: DepartmentData;
}
