export interface FooterLink {
  id: string;
  title: string;
  url?: string | null;
  isInternal?: boolean;
  target?: string | null;
}

export interface FooterCategory {
  id: string;
  title: string;
  url?: string | null;
  children?: FooterLink[];
}

export interface FooterLinksApiResponse {
  success: boolean;
  message: string;
  data: {
    links: FooterCategory[];
  };
}

// ---------- Footer information (contact + socials + badges) ----------

export interface FooterContact {
  address: string;
  primaryPhone: string;
  fax: string;
  email: string;
  latitude: string;
  longitude: string;
  wazeUrlNavigation: string;
  googleMapUrlNavigation: string;
  neshanUrlNavigation: string;
}

export interface FooterSocial {
  title: string;
  icon: string;
  url: string;
}

export interface FooterBadge {
  title: string;
  url: string;
  picture: string;
}

export interface FooterInfoApiResponse {
  success: boolean;
  message: string;
  data: {
    footerText: string;
    contact: FooterContact;
    socialNetworks: FooterSocial[];
    siteBadges: FooterBadge[];
  };
}

// ---------- Final merged data used in FooterClient ----------

export interface FooterData {
  footerText: string;
  contact: FooterContact;
  socials: FooterSocial[];
  badges: FooterBadge[];
  usefulLinks: FooterLink[];
  visitorGuide: FooterLink[];
}
