
export type HeaderLang = {
  name: string;
  code: string;
  flag: string;
  href: string;
};


export type AppointmentItem = {
  title: string;
  href: string;
};


export interface MenuItem {
  id: string;
  title: string;
  url: string | null;
  isInternal?: boolean;
  target?: string;
  children?: MenuItem[];
}


export interface HeaderApiResponse {
  success: boolean;
  message: string;
  data: {
    links: MenuItem[];
  };
}


export type HeaderData = {
  logoMain: string;
  logoSecondary: string;
  title: string;
  subtitle: string;
  languages: HeaderLang[];
  appointmentMenu: AppointmentItem[];
  mainMenu: MenuItem[];
};
