// --- Hero Slider ---
export interface HomeBannerItem {
  id: string;
  src: string;
  alt: string;
  title: string;
  desc: string;
  link: string;
}

export interface HomeBannersSection {
  items: HomeBannerItem[];
}

// --- Services ---
export interface HomeServiceItem {
  title: string;
  src: string;
  alt: string;
  link: string;
  description?: string;
}

export interface HomeServicesSection {
  title: string;
  subtitle: string;
  description: string;
  items: HomeServiceItem[];
}

// --- Doctors ---
export interface HomeDoctorItem {
  id: string;
  slug: string;
  name: string;
  specialty: string;
  image: string;
}

export interface HomeDoctorsSection {
  title: string;
  subtitle: string;
  description: string;
  doctors: HomeDoctorItem[];
}


// --- About ---
export interface HomeAboutSection {
  title: string;
  subtitle: string;
  description: string;
  link: string;

  gallery: {
    big: string;
    small: string;
    smaller: string;
  };

  statistics: {
    id: number;
    value: number;
    label: string;
  }[];
}


// --- Virtual Tours ---
export interface HomeVirtualTourItem {
  id?: number;
  type: "video" | "image";
  src: string; 
  poster?: string | null;
  caption?: string | null;
}

export interface HomeVirtualToursSection {
  title: string;
  subtitle: string;
  description: string;
  items: HomeVirtualTourItem[];
}


// --- Gallery ---
export type GalleryItem = {
  id: number;
  type: "video" | "image";
  src: string; 
  poster?: string | null;
  caption?: string | null;
};

export type HomeGallerySection = {
  title: string;
  subtitle: string;
  description: string;
  items: GalleryItem[];
};


// --- Comments ---
export interface CommentItem {
  fullName: string;
  comment: string;
  picture: string;
}

export interface HomeCommentsSection {
  title: string;     // html string → <strong><span>..</span><label>..</label></strong>
  subtitle: string;  // extracted from HTML
  description: string;
  items: CommentItem[];
}


// --- Insurances ---
export type HomeInsurancesSection = {
  title: string;
  subtitle: string;
  description: string;
  topRow: string[];
  bottomRow: string[];
};


// --- Certificates ---
export type HomeCertificateItem = {
  title: string;
  picture: string;
};

export type HomeCertificatesSection = {
  title: string;
  subtitle: string;
  description: string;
  certificates: string[];
};

// --- Blogs ---
export type BlogTopNews = {
  title: string;
  image: string | null;
  time: string;
  link: string;
};

export type BlogNewsItem = {
  id: number;
  title: string;
  image: string | null; 
  category: string;
  time: string;
  link: string;
};

export type HomeBlogsSection = {
  topNews: BlogTopNews;
  newsList: BlogNewsItem[];
};


// --- FAQs ---
export type HomeFaqItem = {
  id: number;
  question: string;
  answer: string;
};
export type HomeFaqsSection = {
  title: string;
  subtitle: string;
  items: HomeFaqItem[];
};

// ---- Final Home Page Data ----
export interface HomePageData {
  bannersSection: HomeBannersSection;
  servicesSection: HomeServicesSection;
  doctorsSection: HomeDoctorsSection;
  aboutSection: HomeAboutSection;
  virtualToursSection: HomeVirtualToursSection;
  galleriesSection: HomeGallerySection;
  commentsSection: HomeCommentsSection;
  contractedInsurancesSection: HomeInsurancesSection;
  certificatesSection: HomeCertificatesSection;
  blogsSection: HomeBlogsSection;
  faqsSection: HomeFaqsSection;
  socialNetworks: { title: string; icon: string; url: string }[];
}
