// ---------------------------
// API response types
// ---------------------------

/**
 * Single page info returned by Mission API
 */
export interface MissionApiPageInfo {
  title: string;
  content: string | null;
  picture: string | null;

  pageTitle: string;
  pageDescription: string;
  pageRobotsStatus: string;

  ogTitle: string;
  ogDescription: string;
  ogImage: string;

  slug: string;
  canonical: string;
}

/**
 * API response structure for Mission endpoint
 */
export interface MissionApiResponse {
  success: boolean;
  message: string;
  data: {
    pageInfo: MissionApiPageInfo;
  };
}

// ---------------------------
// UI component types
// ---------------------------

/**
 * Final structured data passed to <MissionPage />
 */
export interface MissionPageData {
  title: string;
  image: string;
  html: string;
}
