// src/types/news.ts

export interface NewsPageInfo {
  title: string;
  content: string | null;
  picture: string | null;

  pageTitle: string;
  pageDescription: string;
  pageRobotsStatus: string;

  ogTitle: string;
  ogDescription: string;
  ogImage: string;

  slug: string;
  canonical: string;
}

export interface NewsItem {
  title: string;
  slug: string;
  picture: string;
  publishedDate: string;
  timeStudy: string;
  summary?: string | null;
}
export interface NewsListModel {
  id: number;
  title: string;
  slug: string;
  image: string;
  desc: string;
  date: string;
  readTime: string;
}

export interface NewsCategory {
  title: string;
  slug: string;
}

export interface NewsSections {
  mostViewersSection: NewsItem[];
  popularSection: NewsItem[];
  newestSection: {
    categories: NewsCategory[];
    newest: NewsItem[];
  };
}

export interface NewsApiResponse {
  success: boolean;
  message: string;

  data: {
    pageInfo: NewsPageInfo;
    mostViewersSection: NewsItem[];
    popularSection: NewsItem[];
    newestSection: {
      categories: NewsCategory[];
      newest: NewsItem[];
    };
  };
}
