// --------------------------------------------------
// pageInfo
// --------------------------------------------------
export interface TariffsApiPageInfo {
  title: string;
  pageTitle: string;
  pageDescription: string | null;
  pageRobotsStatus: string | null;

  ogTitle: string | null;
  ogDescription: string | null;
  ogImage: string | null;

  slug: string;
  canonical: string | null;

  content: string | null;
  picture: string | null;
}

// --------------------------------------------------
// Category Section
// --------------------------------------------------
export interface TariffCategory {
  title: string;
  slug: string;
}

export interface TariffCategorySection {
  items: TariffCategory[];
}

// --------------------------------------------------
// Tariff Section
// --------------------------------------------------
export interface TariffDetailItem {
  title: string | null;
  description: string | null;
}

export interface TariffGroup {
  title: string | null;
  items: TariffDetailItem[];
}

export interface TariffSection {
  items: TariffGroup[];
}

// --------------------------------------------------
// Full API response
// --------------------------------------------------
export interface TariffsApiResponse {
  success: boolean;
  message: string;
  data: {
    pageInfo: TariffsApiPageInfo;
    categoriesSection: TariffCategorySection;
    tariffSection: TariffSection;
  };
}

// --------------------------------------------------
// UI data for <TariffsPage />
// --------------------------------------------------
export interface TariffsPageData {
  title: string;
  image: string;
  content: string;

  categories: {
    title: string;
    slug: string;
  }[];

  tariffs: {
    title: string;
    items: {
      title: string;
      description: string;
    }[];
  }[];
}
