// ----------------------------------------
// Tutorials: Page Information Section
// ----------------------------------------
export interface TutorialPageInfo {
  title: string;
  content: string;
  picture: string;
  pageTitle: string;
  pageDescription: string;
  pageRobotsStatus: string;
  ogTitle: string;
  ogDescription: string;
  ogImage: string;
  slug: string;
  canonical: string;
}

// ----------------------------------------
// Tutorials: Most Viewed Items
// ----------------------------------------
export interface TutorialMostViewedItem {
  title: string;
  slug: string;
  picture: string;
  publishedDate: string;
  summary: string;
}

// ----------------------------------------
// Tutorials: Categories
// ----------------------------------------
export interface TutorialCategory {
  title: string;
  slug: string;
}

// ----------------------------------------
// Tutorials: Latest tutorials
// ----------------------------------------
export interface TutorialNewestItem {
  title: string;
  slug: string;
  picture: string;
  publishedDate: string;
  timeStudy: string;
  summary: string;
}

// ----------------------------------------
// Tutorials: Overall output of the Tutorials List API
// ----------------------------------------
export interface TutorialsListResponse {
  pageInfo: TutorialPageInfo;

  mostViewed: TutorialMostViewedItem[];

  newestCategories: TutorialCategory[];

  newest: TutorialNewestItem[];
}
