// ---------------------------
// API response types
// ---------------------------

export interface VisionApiPageInfo {
  title: string;
  content: string | null;
  picture: string | null;

  pageTitle: string;
  pageDescription: string;
  pageRobotsStatus: string;

  ogTitle: string;
  ogDescription: string;
  ogImage: string;

  slug: string;
  canonical: string;
}

export interface VisionApiResponse {
  success: boolean;
  message: string;
  data: {
    pageInfo: VisionApiPageInfo;
  };
}

// ---------------------------
// UI component type
// ---------------------------

export interface VisionPageData {
  title: string;
  image: string;
  html: string;
}
